% LTI for open loop model
function [sys] = lame_lti(mdof,N_motor1,N_motor2,n_1,n_M,freq,Egv,w)

nm = size(Egv,2);
zm = zeros(size(Egv));

% Inputs (drivers) -------------------------------------------------
b_Mot1 = fe_c(mdof,[N_motor1+0.06]',[1])';			
pb1 = Egv'*b_Mot1;
b_Mot2 = fe_c(mdof,[N_motor2+0.06]',[1])';			
pb2 = Egv'*b_Mot2;

pb = [ pb1 pb2 ];
size_pb = size(pb)

% Outputs ---------------------------------------------------------
c_Mot1 = fe_c(mdof,[N_motor1+0.06]',[1]);	
cp1  = c_Mot1*Egv;
c_Mot2 = fe_c(mdof,[N_motor2+0.06]',[1]);	
cp2  = c_Mot2*Egv;
c_S1 = fe_c(mdof,[n_1+0.02]',[1]);	
cps1  = c_S1*Egv;
c_SM = fe_c(mdof,[n_M+0.02]',[1]);	
cpsM  = c_SM*Egv;
c_S2 = fe_c(mdof,[n_M+0.02]',[1]);	
cps2  = c_S2*Egv;

cp = [ cp1 zeros(1,nm); ; cp2 zeros(1,nm); 
      cps1 zeros(1,nm); cpsM zeros(1,nm); cps2 zeros(1,nm) ];

sda = 0.01 		% structural damping = 1/2*Q
damp_col = ones(nm,1)*sda;

n_modes = length(freq)
[a,b,c,d] = nor2ss (freq*2*pi,damp_col,pb,cp);
sys = ss(a,b,c,d);

size_of_sys = size(sys)

my_plot_bode (w,sys(1,1),'b','Sensor - motor-1');
my_plot_bode (w,sys(2,1),'b','N_1 - motor-1');
my_plot_bode (w,sys(3,1),'b','N_m - motor-1');