% ------ topologie -----------------------------------------------
[n_nodes,n_dof,n_elem,n_nel,Dof,Edof] = topol (Coord,Elem);
[Ex,Ey,Ez] = coordxtr (Edof,Coord,Dof,n_nel);

% Check elements
Number_of_elements = size(Elem,1)
Check = length([ eFlex eStiff eMass eAct eH])

figure; femdraw3 (Coord,Ex,Ey,Ez,[1 4 2 5 0.]); 
grid; axis('equal');

Coord_xz(:,1) = Coord(:,1);	Coord_xz(:,2) = Coord(:,3);
figure; femdraw2 (Coord_xz,Ex,Ez,[1 4 2 5 0.]); 
ylabel('z'); grid;
   
Coord_xy(:,1) = Coord(:,1);	Coord_xy(:,2) = Coord(:,2);
figure; femdraw2 (Coord_xy,Ex,Ey,[1 4 2 5 0.]); 
ylabel('y'); grid;

% Calcul des longueurs des lments poutre
for ie = 1:n_elem
   b_elem = [ Ex(ie,2)-Ex(ie,1); Ey(ie,2)-Ey(ie,1); Ez(ie,2)-Ez(ie,1) ];
   L_elem(ie) = sqrt(b_elem'*b_elem);
end
L_elem = L_elem';

