% Eigenmode run

% ------ List masses -----------------------------------------------
for i = 1:n_nodes
  Mass(i) = M((i-1)*n_dof+3, (i-1)*n_dof+3);
end
Masses_for_FEM = [ [1:n_nodes]' Mass' ]
Total_Mass = sum(m_elem)

% ------ Boundary conditions ---------------------------------------
bc = [];
[b,bc,nb] = fix_point (bc,n_fix,Dof);
[b,bc,nb] = fix_xyz   (bc,N_motor1,Dof);
[b,bc,nbc] = fix_1d (b,bc,N_motor1,Dof,[4 5]);
[b,bc,nb] = fix_xyz   (bc,N_motor2,Dof);
[b,bc,nbc] = fix_1d (b,bc,N_motor2,Dof,[4 5]);

disp ('... on calcule les modes propres')
[L,Egv] = eigen (K,M,bc);
freq = sqrt(L)/(2*pi);
disp ('fr?q (Hz) =')
disp (freq(1:5))
n_modes = length (freq)

for i = [1:5]
  plt_mode (Coord,Ex,Ey,Ez,Edof,real(Egv),real(freq),i,0.001);
end

mdof = sdt_mdof(n_nodes,n_dof);



