% Materials
  pois = 0.3;
% Acier
  rho_st = 7800.;
  E_st = 210000e6;	G_st = E_st / (2*(1+pois));
% Alu
  rho_Al = 2800.;
  E_Al = 69000e6;	G_Al = E_Al / (2*(1+pois));

% Geometry
  L = 0.110;    % longueur totale de la poutre
  H = 0.01275;  % hauteur
  W = 0.0005;   % paisseur
  np = 22;      % nombre d'lments
  
  L1 = 0.040;
  L2 = 0.070;
  L3 = 0.100;
    
  HM = 0.040;
  WM = 0.010;
  LM = 0.010;
  
  L_act   = 0.036;
  L_motor = 0.030;
  t_bar = 0.006;

% Constante des moteurs
  Kt = 0.06;    % Nm/A
  Lt = 0.001;   % mH
  Rt = 11;      % Ohm

  
% Properties des lments 
% Lame
h = W;		b = H;
[A, Iy, Iz, J] = rect_pro (b,h);
Ep_lame = [E_st  G_st  A Iy Iz J A*rho_st];

% Masselette
h = WM;		b = WM;
[A, Iy, Iz, J] = rect_pro (b,h);
Ep_block = [E_st  G_st  A Iy Iz J A*rho_st];

% Elment rigide sans masse
r = 0.010;		
[A, Iy, Iz, J] = circ_pro (r);
Ep_stiff = [E_Al  G_Al  A Iy Iz J A*rho_Al/1000];

% Barre de transmission
h = t_bar;		b = t_bar;
[A, Iy, Iz, J] = rect_pro (b,h);
Ep_bar = [E_Al  G_Al  A Iy Iz J A*rho_Al];

% Charnire flexible
h = 1e-4;		b = 1e-4;
[A, Iy, Iz, J] = rect_pro (b,h);
Ep_H = [E_st  G_st  A Iy Iz J*1000 A*rho_st];
