clear
close all
% Materiaux: acier
  pois = 0.3;        rho_st = 7800.;
  E_st = 210000e6;   G_st = E_st / (2*(1+pois));

% Gometrie
  L = 1;       % longueur de la poutre
  % Mu = 1;    % masse au bout de la poutre
  
% Propriets des lments
  A = 7.58e-4; 
  Iy = 6.29e-8;  Iz = 77.8e-8;  J = Iy+Iz;
  Ep_poutre = [E_st  G_st  A Iy Iz J A*rho_st];
  
% geometrie du modle
  Coord (1,:) = [0  0  0];
  Coord (2,:) = [ L 0 0 ];
  Elem(1,:) = [ 1 2 ];
  ePoutre = 1;
  n_fix = 1;  n_free = 2;
  
% Topologie du modle
  n_nodes = 2;
  n_dof = 6;
  n_elem = 1;
  Dof = [ 1     2     3     4     5     6;
          7     8     9    10    11    12 ];
  Edof = ...
  [1     1     2     3     4     5     6     7     8     9    10    11    12];
  Ex = [0 L];
  Ey = [0 0];
  Ez = [0 0];
  
% Plot modle
  Coord_xy(:,1) = Coord(:,1);	
  Coord_xy(:,2) = Coord(:,2);
  figure; femdraw2 (Coord_xy,Ex,Ey,[1 4 2 5 0.]); 
  ylabel('y'); grid;
  
%  Matrices K et M 
  nd = n_nodes*n_dof;
  K = zeros(nd); M = zeros(nd); C = zeros(nd); 
  
  ie = 1;
  eo(ie,:) = [0 0 1];
  [ke,me] = beam3d (Ex(ie,:),Ey(ie,:),Ez(ie,:),eo(ie,:),Ep_poutre);

  K = assem(Edof(ie,:),K,ke);
  M = assem(Edof(ie,:),M,me);

% Eigenmodes and eigenvectors
% we obtain:   n_modes = nomber of computed modes
%              freq = eigenfrequencies (Hz)
%              Egv = eigenvectors

  b = [1:6];   % fixing node 1: Dof 1 to 6
  [L,Egv] = eigen (K,M,b);
  freq = sqrt(L)/(2*pi)  % eigenfrequency in Hz
  n_modes = length (freq)
  
  for i = 1:length(freq)
    forme_t = reshape (Egv(:,i),n_dof,n_nodes); % extracting each mode
    forme = forme_t';
    forme_free(i,:) = forme(n_free,:);
  end
  forme_free    % afficher les formes modales

% One input (actuator) -----------------------------------
  in = zeros(n_nodes*n_dof, 1);
  in(8) = 1;   % DoF dir Y de n_free
  inm = Egv'*in;                           % modal forces

% One output ------------------------------------------------
  out = zeros(1, n_nodes*n_dof);
  out(8) = 1;   % DoF dir Y de n_free
  outm  = [ out*Egv   zeros(1,n_modes) ];  % modal displacements

  freqvec = logspace(0,3,100)'; % de 0  1000 Hz  logarithmic scale
  w=2*pi*freqvec;               % pulsations vector in rad/s
  om = 2*pi*freq;           % eigenfrequencies in rad/s
  sda = 0.002;              % structural damping = 1/2*Q
  
  xf = nor2xf (om,sda,inm,outm,w);
  figure; loglog (freqvec,abs(xf)); grid 
  title ('Response in frequency for F = 1 N'); xlabel('Hz')

  [a,b,c,d] = nor2ss (om,sda,inm,outm);  % modle state space
  sys = ss(a,b,c,d);
  size_of_sys = size(sys)
  my_plot_bode (w, sys(1,1),'b','Respose at the end of the beam');

% Boundary conditions
bc = [];  [b,bc,nb] = fix_point (bc, n_fix, Dof);

%  On dfinit les forces et moments
p = zeros(size(K,1),1);
i = n_free;  dof_exc = (i-1)*n_dof+2;
p(dof_exc) = 10;   % N

[X, R, xyzF] = fe_stat (K,p,b,n_dof,n_nodes);

Edb = extract (Edof,X);	
figure; femdraw2 ([Coord(:,1) Coord(:,2)],Ex,Ey,[1 4 2 5 0.]); 
Edbxy = [Edb(:,1) Edb(:,2) Edb(:,6) Edb(:,7) Edb(:,8) Edb(:,12)];
femdisp2 (Ex,Ey,Edbxy);  ylabel('y');
title('Static computation  1N force along Y at node 2');

disp('Node displacements(mm)');
disp (xyzF*1000)

