% Calcul statique
% ------ Boundary conditions ---------------------------------------
bc = [];
[b,bc,nb] = fix_point (bc,n_fix,Dof);

%  ------ Load - Z moment ----------------------------------
p = zeros(size(K,1),1);
i = n_act
   dof_exc = (i-1)*n_dof+2;
   p(dof_exc) = 0.1;   % N

[X,R,xyzF] = fe_stat (K,p,b,n_dof,n_nodes);

Edb = extract (Edof,X);	
figure; femdraw2 ([Coord(:,1) Coord(:,2)],Ex,Ey,[2 4 2 4 0.]); 
Edbxy = [Edb(:,1) Edb(:,2) Edb(:,6) Edb(:,7) Edb(:,8) Edb(:,12)];
femdisp2 (Ex,Ey,Edbxy,[1 5 0 5],1); ylabel('y');
title('analyse static - force 0.1 N au noeud 3');

disp ('Dplacements des noeuds (mm)');
disp (xyzF*1000)
