% Fonction de transfert
mdof = sdt_mdof(n_nodes,n_dof);

% 1 input (actionneur) -----------------------------------
b_act = fe_c (mdof,[n_act+0.02]',[1])';			
pb1 = Egv'*b_act;
pb = [ pb1 ];

% 2 outputs ------------------------------------------------
c_act = fe_c(mdof,[n_act+0.02]',[1]);	
cp1  = c_act*Egv;
c_mass = fe_c(mdof,[n_mass+0.02]',[1]);	
cp2  = c_mass*Egv;
cp = [ cp1 zeros(1,n_modes); cp2 zeros(1,n_modes) ];

sda = 0.005;   %  amortissement structurel = 1/2*Q

freqvec = logspace(0,3,100)'; % de 0  1000 Hz	
w=2*pi*freqvec;               % omega
freqrad = 2*pi*freq;   % nos frquences propres en rad/s

[a,b,c,d] = nor2ss (freqrad,sda,pb,cp);
sys = ss(a,b,c,d);
size_of_sys = size(sys)
my_plot_bode (w,sys(1,1),'b','act - act');
my_plot_bode (w,sys(2,1),'r','masse - act');

