function [n_nodes,n_dof,n_elem,n_nel,Dof,Edof] = topol (Coord,Elem)
% FEM topology
% n_nodes = no. of nodes
% n_dof = no. of DoF of each node
% n_elem = no. of elements
% n_nel = no. of nodes per elements
% Dof = degrees of freedom of each node (une line per node)
% Edof = [element no, degrees of freedom of the element] (une line per
%        element)

n_nodes = size(Coord,1);
n_dim = size(Coord,2);
n_elem = size(Elem,1);
n_nel = size(Elem,2);

% ------ list of degrees-of-fredom  -----------------------------
if n_dim == 2 
  n_dof = 3;
elseif n_dim == 3
  n_dof = 6;
end
Dof = zeros(n_nodes,n_dof);
last = 0;
for i = 1:n_nodes
  for j = 1:n_dof
    last = last+1; Dof(i,j) = last; 
  end
end

% ------ topology -----------------------------------------------
Edof = zeros(n_elem,n_dof*n_nel);
for i = 1:n_elem
  Edof(i,1) = i;
  for j = 1:n_nel
    for k = 1:n_dof
      if Elem(i,j) == 0
        Edof(i,1+(j-1)*n_dof+k) = 0;
      else
        Edof(i,1+(j-1)*n_dof+k) = Dof(Elem(i,j),k);
      end
    end
  end
end
%--------------------------end--------------------------------