% Section properties for a rectangular cross-section
% function [A, Iy, Iz, J] = rect_pro (b,h)
%
% b along z
% h along y 
function [A, Iy, Iz, J] = rect_pro (b,h) 
 A = b*h;
 Iz = b*h^3/12;	
 Iy = h*b^3/12; 
 if (b < h)
   b0 = b;
   b = h;
   h = b0;
end
if (b>=h)
   J = b/2*(h/2)^3*(16/3-3.36*h/b*(1-(h/2)^4/(12*(b/2)^4)));
else
   h1 = h;
   h = b;
   b = h1;
   J = b/2*(h/2)^3*(16/3-3.36*h/b*(1-(h/2)^4/(12*(b/2)^4)));
end
