% ----- plot one eigenmode ---------------------------------------

function Mag = plt_mode (Coord,Ex,Ey,Ez,Edof,Egv,Freq,Nf,Mag)
 if nargin <= 8; 
      Mag = 0.2; 
 end 
 T = ['Eigenmode nr. ' num2str(Nf) '    f = ' num2str(Freq(Nf),'%10.1f') ' Hz']; 
 figure
 Edb=extract(Edof,Egv(:,Nf));  
 subplot (2,2,1)
 femdraw3 (Coord,Ex,Ey,Ez,[1 4 2 4 0.]); 
 femdisp3 (Ex,Ey,Ez,Edb,[1 5 0 5],Mag); grid;
 title(T)
 
 subplot (2,2,2)
 femdraw2 (Coord,Ex,Ey,[2 4 2 4 0.]); 
 Edbxy = [Edb(:,1) Edb(:,2) Edb(:,6) Edb(:,7) Edb(:,8) Edb(:,12)];
 femdisp2 (Ex,Ey,Edbxy,[1 5 0 5],Mag); 
 
 subplot (2,2,3)
 femdraw2 ([Coord(:,1) Coord(:,3)],Ex,Ez,[2 4 2 4 0.]); 
 Edbxz = [Edb(:,1) Edb(:,3) Edb(:,5) Edb(:,7) Edb(:,9) Edb(:,11)];
 femdisp2 (Ex,Ez,Edbxz,[1 5 0 5],Mag); ylabel('z')
 
 subplot (2,2,4)
 femdraw2 ([Coord(:,2) Coord(:,3)],Ey,Ez,[2 4 2 4 0.]); 
 Edbyz = [Edb(:,2) Edb(:,3) Edb(:,4) Edb(:,8) Edb(:,9) Edb(:,10)];
 femdisp2 (Ey,Ez,Edbyz,[1 5 0 5],Mag); xlabel('y'); ylabel('z')

