 function [Ke,Me,Ce]=joint3d (ex,ey,ez,eo,ep)
%----------------------------------------------------------------
%    PURPOSE
%       Calculate the stiffness matrix Ke and the mass matrix Me
%       for a 3D elastic Bernoulli beam element. 
% 
%    INPUT:  ex = [x1 x2]        
%            ey = [y1 y2]   
%            ez = [z1 z2]       node coordinates  
%
%            eo = [xz yz zz];   orientation of local z axis
%
%            ep = [Ke Me aa bb]; 
%                               element properties 
%                            K: Stiffness
%                            M: Mass
%                          aa,bb: damping coefficients,
%                                 Ce=aMe+bKe 
%
%    OUTPUT: Ke : beam stiffness matrix (12 x 12)
%            Me : element mass matrix 
%
%-----------------------------------------------------------------  

  b=[ ex(2)-ex(1); ey(2)-ey(1); ez(2)-ez(1) ];
  L=sqrt(b'*b);  n1=b/L;

  lc=sqrt(eo*eo'); n3=eo/lc;
  %
    m= M/L;
    if length(ep)==4 
      aa=ep(8) ; bb=ep(9) ;
    else
      aa = 0; 	bb = 0;
    end
 
    a = Ke;  b = a; d = a;

    Kle=[a  0  0  0  0  0 -a  0  0  0  0  0 ;
         0  b  0  0  0  0  0 -b  0  0  0  0 ;
         0  0  d  0  0  0  0  0 -d  0  0  0 ;
         0  0  0  0  0  0  0  0  0  0  0  0 ;
         0  0  0  0  0  0  0  0  0  0  0  0 ;
	   0  0  0  0  0  0  0  0  0  0  0  0 ;
        -a  0  0  0  0  0  a  0  0  0  0  0 ;
         0 -b  0  0  0  0  0  b  0  0  0  0 ;
         0  0 -d  0  0  0  0  0  d  0  0  0 ;
         0  0  0  0  0  0  0  0  0  0  0  0 ;
         0  0  0  0  0  0  0  0  0  0  0  0 ;
         0  0  0  0  0  0  0  0  0  0  0  0 ];
%
   Mle=m*L/420*[
        140   0    0    0    0    0   70    0    0    0    0    0   ;
         0   156   0    0    0    0    0   54    0    0    0    0   ;
         0    0   156   0    0    0    0    0   54    0   0     0   ;
         0    0    0    0    0    0    0    0    0    0    0    0   ;
         0    0    0    0    0    0    0    0    0    0    0    0   ;
         0    0    0    0    0    0    0    0    0    0    0    0   ;
        70    0    0    0    0    0   140   0    0    0    0    0   ;
         0   54    0    0    0    0    0   156   0    0    0    0   ;
         0    0   54    0    0    0    0    0   156   0    0    0   ;
         0    0    0    0    0    0    0    0    0    0    0    0   ;
         0    0    0    0    0    0    0    0    0    0    0    0   ;
         0    0    0    0    0    0    0    0    0    0    0    0   ;

 
%
    n2(1)=n3(2)*n1(3)-n3(3)*n1(2);
    n2(2)=-n1(3)*n3(1)+n1(1)*n3(3);
    n2(3)=n3(1)*n1(2)-n1(1)*n3(2);
%
    An=[n1';
        n2;
        n3];
%
%
   Cle=aa*Mle+bb*Kle;
%
    G=[  An     zeros(3) zeros(3) zeros(3);
       zeros(3)   An     zeros(3) zeros(3);
       zeros(3) zeros(3)   An     zeros(3);
       zeros(3) zeros(3) zeros(3)   An    ];
%
   Ke1=G'*Kle*G;    Me1=G'*Mle*G;    Ce1=G'*Cle*G;
 %----------------------------------------------------------   
    if nargout==0
      disp('Element stiffness matrix: ');
      disp(Ke1);
      disp('Element mass matrix: ');
      disp(Me1);
      return 
    end
    Ke=Ke1;
    Me=Me1;
    Ce=Ce1;
 %-------------------------- end -------------------------------
