 function [Ke,Me,Ce]=joint3d (ex,ey,ez,eo,K,aa,bb)
%----------------------------------------------------------------
%    PURPOSE
%       Calculate the stiffness matrix Ke and the mass matrix Me
%       for a 3D elastic Bernoulli beam element. 
% 
%    INPUT:  ex = [x1 x2]        
%            ey = [y1 y2]   
%            ez = [z1 z2]       node coordinates  
%
%            eo = [xz yz zz];   orientation of local z axis
%
%            K : Stiffness
%            aa,bb: damping coefficients,
%                   Ce = aa M e+ bb Ke 
%
%    OUTPUT: Ke : beam stiffness matrix (12 x 12)
%            Me : element mass matrix 
%
%-----------------------------------------------------------------  

  b=[ ex(2)-ex(1); ey(2)-ey(1); ez(2)-ez(1) ];
  L=sqrt(b'*b);  n1=b/L;

  lc=sqrt(eo*eo'); n3=eo/lc;
  %
    a = K;  b = a;   d = a;

    h = 1e-4;       b = 1e-4;
    [A, Iy, Iz, J] = rect_pro (b,h);
    epd = [200e9  75e9  A Iy Iz J*1000 A*7800];

    E=epd(1); Gs=epd(2);
    A=epd(3);
    Iy=epd(4); Iz=epd(5);
    Kv=epd(6);
    m = epd(7);

    c=6*E*Iz/L^2;
    e=6*E*Iy/L^2  ; f=Gs*Kv/L;
    g=2*E*Iy/L    ; h=2*E*Iz/L    ; k=(Iy+Iz)/A;

    Kle=[a  0  0  0  0  0 -a  0  0  0  0  0 ;
         0  b  0  0  0  c  0 -b  0  0  0  c ;
         0  0  d  0 -e  0  0  0 -d  0 -e  0 ;
         0  0  0  f  0  0  0  0  0 -f  0  0 ;
         0  0 -e  0 2*g 0  0  0  e  0  g  0 ;
         0  c  0  0  0 2*h 0 -c  0  0  0  h ;
        -a  0  0  0  0  0  a  0  0  0  0  0 ;
         0 -b  0  0  0 -c  0  b  0  0  0 -c ;
         0  0 -d  0  e  0  0  0  d  0  e  0 ;
         0  0  0 -f  0  0  0  0  0  f  0  0 ;
         0  0 -e  0  g  0  0  0  e  0 2*g 0 ;
         0  c  0  0  0  h  0 -c  0  0  0 2*h];
%
   Mle=m*L/420*[
        140   0    0    0    0    0   70    0    0    0    0    0   ;
         0   156   0    0    0   22*L  0   54    0    0    0  -13*L ;
         0    0   156   0  -22*L  0    0    0   54    0   13*L  0   ;
         0    0    0  140*k  0    0    0    0    0   70*k  0    0   ;
         0    0  -22*L  0   4*L^2 0    0    0 -13*L   0  -3*L^2 0   ;
         0   22*L  0    0    0  4*L^2  0  13*L   0    0    0  -3*L^2 ;
        70    0    0    0    0    0   140   0    0    0    0    0   ;
         0   54    0    0    0   13*L  0   156   0    0    0  -22*L ;
         0    0   54    0  -13*L  0    0    0   156   0   22*L  0   ;
         0    0    0  70*k   0    0    0    0    0  140*k  0    0   ;
         0    0  13*L   0 -3*L^2  0    0    0   22*L  0  4*L^2  0   ;
         0  -13*L  0    0    0 -3*L^2  0 -22*L   0    0    0  4*L^2 ];
     
     % lumped mass matrix
   Mle = eye(12);
   for i = 4:6
     Mle(i,i) = L^2/12;
     Mle(i+6,i+6) = L^2/12;
   end
   Mle=m*L/2 * Mle;

%
    n2(1)=n3(2)*n1(3)-n3(3)*n1(2);
    n2(2)=-n1(3)*n3(1)+n1(1)*n3(3);
    n2(3)=n3(1)*n1(2)-n1(1)*n3(2);
%
    An=[n1';
        n2;
        n3];
%
    if (nargin < 7)
       aa = 0; 	bb = 0;
    end
    Cle=aa*Mle+bb*Kle;   
%
    G=[  An     zeros(3) zeros(3) zeros(3);
       zeros(3)   An     zeros(3) zeros(3);
       zeros(3) zeros(3)   An     zeros(3);
       zeros(3) zeros(3) zeros(3)   An    ];
%
   Ke1=G'*Kle*G;    Me1=G'*Mle*G;    Ce1=G'*Cle*G;
 %----------------------------------------------------------   
    if nargout==0
      disp('Element stiffness matrix: ');
      disp(Ke1);
      disp('Element mass matrix: ');
      disp(Me1);
      return 
    end
    Ke=Ke1;
    Me=Me1;
    Ce=Ce1;
 %-------------------------- end -------------------------------
