function femdraw3(coord,ex,ey,ez,plotpar,elnum)
%-------------------------------------------------------------
% PURPOSE 
%   Draw the undeformed 3D mesh for a number of elements of 
%   the same type. Supported elements are:
% 
%   1) -> bar element              2) -> beam el. 
%    
%   next:[ 3) -> tetraheder 3 node el.    4) -> brick 8 node el.]
%
% INPUT 
%    ex,ey,ez:.......... nen:   number of element nodes
%                        nel:   number of elements   
%    plotpar=[ linetype, linecolor, nodemark]
% 
%             linetype=1 -> solid    linecolor=1 -> white
%                      2 -> dashed             2 -> green
%                      3 -> dotted             3 -> yellow
%                                              4 -> red
%
%             nodemark=1 -> circle       
%                      2 -> star               
%                      0 -> no mark 
%
%    elnum=edof(:,1) ;i.e. the first column in the topology matrix            
%               
%    Rem. Default is solid white lines with circles at nodes.
%         
%-------------------------------------------------------------

% LAST MODIFIED: P-E Austrell 1994-01-05 
% Copyright (c)  Division of Structural Mechanics and
%                Department of Solid Mechanics.
%                Lund Institute of Technology
%-------------------------------------------------------------
%
 if ~((nargin==4)|(nargin==5)|(nargin==6))
    disp('??? Wrong number of input arguments!')
    return
 end 
 
 a=size(ex); b=size(ey); c=size(ez);
 
 if ((a-b)==[0 0])&((b-c)==[0 0])
    nel=a(1);  nen=a(2);
 else
    disp('??? Check size of coordinate input arguments!')
    return
 end
 if nargin==4; 
      plotpar=[1 4 2 5 0]; 
 end
 
 [s1,s2,p5] = pltstyl1(plotpar);
 
% ************************************************** 
% ************* plot coordinates *******************
% ************************************************** 
 x0=sum(ex')/nen; 
 y0=sum(ey')/nen; 
 z0=sum(ez')/nen;
  
% ********** Bar or Beam elements *************
 if nen==2
    x=ex'; y=ey'; z=ez';  
    xc=x; yc=y; zc=z;
% ********* 2D quadrilateral elements *********
 elseif nen==4 
    x=ex' ;
    y=ey';   
    xc=[x ; x(1,:)]; 
    yc=[y ; y(1,:)];
    z=ez' ;
    zc=[z ; z(1,:)];
%********************************************************** 
 else
    disp('!!! Sorry, this element is currently not supported!')
    return      
 end
  
%*************************************************
% ************** plot commands *******************
%*************************************************
 axis('square')
 hold on  
 view(3)
 plot3(xc,yc,zc,s1)   
 plot3(coord(:,1),coord(:,2),coord(:,3),s2)
 n_nodes = size(coord,1);
 scale = get(gca,'zlim'); dsz = scale(2)/50;
 scale = get(gca,'xlim'); dsx = scale(2)/50; 
 scale = get(gca,'ylim'); dsy = scale(2)/50; 
 for i = 1:n_nodes
   hh=text(coord(i,1)+dsx,coord(i,2)+dsy,coord(i,3)+dsz,int2str(i));
   set(hh,'Color',s2(length(s2)))
   set(hh,'fontsize',10);
 end
 if nargin==6
    for i=1:nel
       h = text(x0(i),y0(i),z0(i),int2str(elnum(i)));
       set(h,'Color',s1(length(s1)))
       set(h,'fontsize',10);
    end 
 end
 xlabel('x'); ylabel('y'); zlabel('z');
 hold off 
 if (p5 == 1)
   xlim = get(gca,'xlim'); rx = abs(xlim(2)-xlim(1));
   zlim = get(gca,'zlim'); rz = abs(zlim(2)-zlim(1)); 
   if (rz < rx)
     zlim = zlim *rx/rz;
     set(gca,'zlim',[zlim(1),zlim(2)]);
   end
 end
%--------------------------end-------------------------------- 
