function [o1,o2,o3]=fe_c(mdof,adof,c,opt)

%FE_C DOF selection and I/O shape matrix construction
%
%	Synopsis : c            = fe_c(mdof,adof)
%	           c            = fe_c(mdof,adof,cin,opt)
%		   [adof,ind,c] = fe_c(mdof,adof,cin,opt)
%		   ind          = fe_c(mdof,adof,'ind')
%		   adof         = fe_c(mdof,adof,'dof')
%		   b            = fe_c(mdof,adof)'
%
%	FE_C is used both
%	 to characterize sensors/actuators by the output C or input B matrix
%        to select DOFs (in particular to impose boundary conditions)
%
%	The input arguments are
%
%	MDOF main DOF definition vector. Each element of this column vector
%	defines a DOF following the format 
%	   NodeID.DofID for nodal DOFs (with DOFs 01 to 99 accepted). For
%	      example the value 100.01 indicates the x translation at node 100)
%	      By default DOFs .01 to .06 are xyz translations/rotations.
%	      DOFs .07 to .12 are reserved for -x-y-z translations/rotations
%	      but should not be used in finite element analysis.
%	  -EltID.DofID  for element DOFs (DOFs 1 to 999 are accepted). The 
%	      EltID value is discussed in the tutorial section of the manual.
%	ADOF gives the DOF that are used for the initial definition of c
%            Accepted simplifications (wild cards) are
%	       10.0 all DOFs (01 to 06 in general) of node 10
%		0.1 x-translations at all nodes
%	      -10.0 all internal DOFs of element 10
%	CIN  describes different outputs (one per row) in the DOFs ADOF
%	     if not specified or empty C is taken to be the identity matrix
%	     If the strings 'dof' or 'ind' are used instead of CIN the first
%	     and only output argument is ADOF or IND respectively.
%	OPT   (optional)
%	     OPT = 1  keeps the DOFs in ADOF (this is the default)
%	     OPT = 2  keeps the DOFs that are not in ADOF
%	
%	The output arguments are
%
%	C    the output shape matrix in model DOFs described by MDOF
%	     (if only one output argument is asked, this argument is C and
%	      not the expanded ADOF)
%	ADOF expanded (without wild cards) version of the input
%	     argument ADOF (or its complementary if OPT==2)
%	IND  indices of the ADOF DOFs in MDOF (i.e. ADOF = MDOF(IND))
%
%	WARNING: FE_C supports the convention that nodal DOFs .07 to .12 are
%	     the opposite of nodal DOFs .01 to .06
%
%	See also FE_EIG, FE_MK, NOR2SS, NOR2XF

%	Etienne Balmes  02/18/93, 05/09/96
%       Copyright (c) 1990-1996 by Etienne Balmes
%       All Rights Reserved.


if size(adof,1)==1 & size(adof,2)~=1 adof=adof(:);
   disp(['FE_C WARNING: active DOFs should be specified as a column' 7]);
end
if nargin<3 c = []; end
if nargin<4 opt=1; elseif isempty(find([1 2]==opt)) opt = 1; end

adof=round(adof(:,1)*1000); mdof=round(mdof(:,1)*1000);
i3=rem(adof(:,1),1000); % DofID
i4=adof(:,1)-i3;        % NodeID or EltID
i1=diff(sort(mdof));if ~all(i1) error('Repeated DOFs in mdof');end

ind=find(mdof>0);cind=find(mdof<0);

in2=find(i3>69&i3<121);
if ~isempty(in2) adof(in2)=adof(in2)-60;i3(in2)=i3(in2)-60; end
in1=find(mdof>0&rem(mdof,1000)<121&rem(mdof,1000)>69);
if ~isempty(in1) mdof(in1)=mdof(in1)-60; end
rdof = [];

% mdof=1+[1:6]'/100;mdof=[mdof;mdof+2];fe_c2(mdof,.01,'ind')

% no wild cards - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

i5=find(i3&i4);
if ~isempty(i5)
  [i6,i7]=sort([mdof;adof(i5)]);
  %position in i7 of retained mdof dofs
  i8=find(~diff(i6));
  i8=i8(find(i7(i8)<=length(mdof)));
  [i9,i10]=sort(i7(i8+1)); % sort using first appearance in adof
  rdof=i7(i8(i10));        % indices of retained DOFs in mdof
  opt(2)=1;
  if ~isstr(c)&size(c,2)==size(adof,1)
    c=c(:,i5(i9-length(mdof)));
  end %if some DOF eliminated
end

% NodeDOF ID wild card  - - - - - - - - - - - - - - - - - - - - - - - - - -
i5=find(i3>0&~i4);if ~isempty(i5)
  i6=[];i6(i3(i5),1)=[1:length(i5)]';
  i7=rem(mdof,1000);if length(i6)<max(i7) i6(max(i7))=0;end
  rdof=[rdof;find(i6(i7))];
  opt(2)=0;
end

% EltDOF ID wild card  - - - - - - - - - - - - - - - - - - - - - - - - - -

i5=find(i3<0&~i4);if ~isempty(i5)
  i6(-i3(i5),1)=[1:length(i5)]';
  i7=-rem(mdof(cind),1000);
  if length(i6)<max(i7) i6(max(i7))=0;end
  rdof=[rdof;cind(find(i6(i7)))];
end

% NodeID wild card - - - - - - - - - - - - - - - - - - - - - - - - - - - -

i5=find(~i3&i4>0);if ~isempty(i5)
  i6=[];i6(i4(i5)/1000,1)=[1:length(i5)]';
  i7=fix(mdof(ind)/1000);
  if ~isempty(i7)
    if length(i6)<max(i7) i6(max(i7))=0;end
    i8=find(i6(i7));i7=i6(i7(i8));  [i7,i9]=sort(i7); % declared node order
    rdof=[rdof;ind(i8(i9))];
  end
  opt(2)=0; if length(i5)==length(adof) opt(2)=1;end
end

% EltID wild card - - - - - - - - - - - - - - - - - - - - - - - - - - - -

i5=find(~i3&i4<0);if ~isempty(i5)
    i10=[rem(-mdof(cind),1000) round(rem(-mdof(cind),1e6)/1e3) ...
         round(-mdof(cind)/1e6)];
    i8=[rem(-adof(i1(i7)),1000) round(rem(-adof(i1(i7)),1e6)/1e3) ...
          round(-adof(i1(i7))/1e6)];
    i11=max([i10;i8])+1;i11=[i11(1) i11(2)*i11(1) i11(2)*i11(1)*i11(3)];
    i7=[i8(1):i11(1):i11(3)];
    i12=sparse(i10(:,1)+i10(:,2)*i11(1)+i10(:,3)*i11(2),1,1:size(i10,1));
    i7=i12(i7);i7=full(i7(find(i7)));
    rdof=[rdof;cind(i7)];
  opt(2)=0;
end

% Cleaning up  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

% eliminates duplicates in rdof but sorts DOFs
if opt(2)~=1 rdof=find(sparse(rdof,1,rdof)); end

if opt(1)==2
  i1=1:size(mdof,1);i1(rdof)=zeros(1,length(rdof));rdof=find(i1);rdof=rdof(:);
end

if nargout==2		o1=mdof(rdof)/1000;o2=full(rdof);
elseif isstr(c)
   if     strcmp(c,'ind') o1 = full(rdof); o2=[];
   elseif strcmp(c,'dof') o1 = mdof(rdof)/1000; o2=[]; end
else
  if isempty(c) c=speye(length(rdof)); end
  if size(c,2)~=length(adof) & ~isempty(in2)
    disp('FE_C WARNING Sign change for DOFs .01-.06 to .07-.12 not performed');
    in1=[];in2=[];
  end
  if length(rdof)~=size(c,2)
      error('adof does not correspond to the number of columns in c');
  end
  if ~isempty(in2)     c(:,in2)=-c(:,in2);      end
  co = spalloc(size(c,1),length(mdof),1); co(:,rdof) = c;
  if ~isempty(in1)     co(:,in1)=-co(:,in1);      end
  if nargout<2 o1=co; else o1=mdof(rdof)/1000;o2=full(rdof);o3=co; end
end

