function eo = eo_beam (ie,Ex,Ey,Ez)
  x = Ex(ie,2)-Ex(ie,1);	
  y = Ey(ie,2)-Ey(ie,1);	
  z = Ez(ie,2)-Ez(ie,1);	
  
  if (y == 0)  
     eo = [ 0 1 0 ];
  elseif (z == 0)  
     eo = [ 0 0 1 ];
  else
     eo(2) = -(x^2/y + z^2/y) / (1 + x^2/y^2 + z^2/y^2);
     eo(3) = z * (eo(2)/y +1);
     eo(1) = x * eo(3)/z;
  end
  